<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Verify\V2\Service;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;

class VerificationCheckList extends ListResource {
    /**
     * Construct the VerificationCheckList
     *
     * @param Version $version Version that contains the resource
     * @param string $serviceSid The SID of the Service that the resource is
     *                           associated with
     * @return \Twilio\Rest\Verify\V2\Service\VerificationCheckList
     */
    public function __construct(Version $version, $serviceSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array('serviceSid' => $serviceSid, );

        $this->uri = '/Services/' . \rawurlencode($serviceSid) . '/VerificationCheck';
    }

    /**
     * Create a new VerificationCheckInstance
     *
     * @param string $code The verification string
     * @param array|Options $options Optional Arguments
     * @return VerificationCheckInstance Newly created VerificationCheckInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create($code, $options = array()) {
        $options = new Values($options);

        $data = Values::of(array(
            'Code' => $code,
            'To' => $options['to'],
            'VerificationSid' => $options['verificationSid'],
            'Amount' => $options['amount'],
            'Payee' => $options['payee'],
        ));

        $payload = $this->version->create(
            'POST',
            $this->uri,
            array(),
            $data
        );

        return new VerificationCheckInstance($this->version, $payload, $this->solution['serviceSid']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.Verify.V2.VerificationCheckList]';
    }
}